/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.util;

import com.aptana.core.ShellExecutable;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.StringUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

public class PathUtil {
    private static final String PATHS_SEPERATOR = ":";
    private static final String UNIX_SEPERATOR = "/";
    private static final Pattern MINGW_PATH_REGEXP = Pattern.compile("^/(.)/(.*)");
    private static final Pattern CYGWWIN_PATH_REGEXP = Pattern.compile("^/cygdrive/(.)/(.*)");

    public static String convertToUnixFormatPath(String windowsPath) {
        String unixPath = windowsPath.replace(PATHS_SEPERATOR, "");
        unixPath = unixPath.replace('\\', '/');
        unixPath = StringUtil.concat(UNIX_SEPERATOR, unixPath, UNIX_SEPERATOR);
        return unixPath;
    }

    public static String convertPATH(String rawPATH) {
        if (rawPATH == null || !PlatformUtil.isWindows()) {
            return rawPATH;
        }
        if (rawPATH.indexOf(59) != -1) {
            return rawPATH;
        }
        if (rawPATH.contains("/cygdrive/")) {
            try {
                String cygPathExe = ShellExecutable.getPath().removeLastSegments(1).append("cygpath.exe").toOSString();
                IStatus result = new ProcessRunner().runInBackground(cygPathExe, "-w", "-p", rawPATH);
                if (result.isOK()) {
                    return result.getMessage();
                }
            }
            catch (CoreException cygPathExe) {
                // empty catch block
            }
        }
        String[] paths = rawPATH.split(PATHS_SEPERATOR);
        int i = 0;
        while (i < paths.length) {
            Matcher m = MINGW_PATH_REGEXP.matcher(paths[i]);
            if (m.matches()) {
                paths[i] = m.replaceFirst("$1:/$2");
            } else {
                m = CYGWWIN_PATH_REGEXP.matcher(paths[i]);
                if (m.matches()) {
                    paths[i] = m.replaceFirst("$1:/$2");
                }
            }
            ++i;
        }
        return StringUtil.join(File.pathSeparator, paths);
    }
}

